#ifndef _DEVCTLPTZ_H_
#define _DEVCTLPTZ_H_

#include "dllexport.h"

class IDevUserLogin;
class IDevPreview;

enum tagEnumDevPresetCmdType 
{
	DEV_SET_PRESET = 8,
	DEV_CLE_PRESET = 9,
	DEV_GOTO_PRESET = 39
};

enum tagEnumDevCruiseCmdType
{
	DEV_FILL_PRE_SEQ  = 30, //ԤõѲ 
	DEV_SET_SEQ_DWELL = 31, //Ѳͣʱ 
	DEV_SET_SEQ_SPEED = 32, //Ѳٶ 
	DEV_CLE_PRE_SEQ   = 33, //ԤõѲɾ 
	DEV_RUN_SEQ       = 37, //ʼѲ 
	DEV_STOP_SEQ      = 38, //ֹͣѲ 
    DEV_SEQ_END       = 39
};

enum tagEnumDevControlCmdType
{
    DEV_CONTROL_CMD_LIGHT_PWRON		= 2,		/* ͨƹԴ */
    DEV_CONTROL_CMD_WIPER_PWRON		= 3,		/* ͨˢ */
    DEV_CONTROL_CMD_FAN_PWRON 		= 4,		/* ͨȿ */
    DEV_CONTROL_CMD_HEATER_PWRON 	= 5,		/* ͨ */
    DEV_CONTROL_CMD_AUX_PWRON1		= 6,		/* ͨ豸 */	
    DEV_CONTROL_CMD_AUX_PWRON2 		= 7,		/* ͨ豸 */
    DEV_CONTROL_CMD_SET_PRESET		= 8,		/* Ԥõ */
    DEV_CONTROL_CMD_CLE_PRESET 		= 9,		/* Ԥõ */

    DEV_CONTROL_CMD_ZOOM_IN 		= 11, 		// 
    DEV_CONTROL_CMD_ZOOM_OUT		= 12,		// С
    DEV_CONTROL_CMD_FOCUS_NEAR		= 13,		// ǰ
    DEV_CONTROL_CMD_FOCUS_FAR		= 14,		// 
    DEV_CONTROL_CMD_IRIS_OPEN		= 15,		// Ȧ 
    DEV_CONTROL_CMD_IRIS_CLOSE		= 16,		// Ȧ 

    DEV_CONTROL_CMD_TILT_UP			= 21,		/* ̨SSٶ */
    DEV_CONTROL_CMD_TILT_DOWN 		= 22,		/* ̨SSٶ¸ */
    DEV_CONTROL_CMD_PAN_LEFT 		= 23,		/* ̨SSٶת */
    DEV_CONTROL_CMD_PAN_RIGHT 		= 24,		/* ̨SSٶת */
    DEV_CONTROL_CMD_UP_LEFT 		= 25,		/* ̨SSٶת */
    DEV_CONTROL_CMD_UP_RIGHT 		= 26,		/* ̨SSٶת */
    DEV_CONTROL_CMD_DOWN_LEFT 		= 27,		/* ̨SSٶ¸ת */
    DEV_CONTROL_CMD_DOWN_RIGHT 		= 28,		/* ̨SSٶ¸ת */
    DEV_CONTROL_CMD_PAN_AUTO 		= 29,		/* ̨SSٶԶɨ */

	DEV_CONTROL_CMD_FILL_PRE_SEQ	= 30,	    /* ԤõѲ */
	DEV_CONTROL_CMD_SET_SEQ_DWELL	= 31,	    /* Ѳͣʱ */
	DEV_CONTROL_CMD_SET_SEQ_SPEED	= 32,	    /* Ѳٶ */
	DEV_CONTROL_CMD_CLE_PRE_SEQ	    = 33,	    /* ԤõѲɾ */
	DEV_CONTROL_CMD_STA_MEM_CRUISE	= 34,	    /* ʼ¼켣 */
	DEV_CONTROL_CMD_STO_MEM_CRUISE	= 35,	    /* ֹͣ¼켣 */
	DEV_CONTROL_CMD_RUN_CRUISE		= 36,	    /* ʼ켣 */
	DEV_CONTROL_CMD_RUN_SEQ		    = 37,	    /* ʼѲ */
	DEV_CONTROL_CMD_STOP_SEQ		= 38,	    /* ֹͣѲ */
	DEV_CONTROL_CMD_GOTO_PRESET	    = 39,	    /* תԤõ */

    DEV_CONTROL_CMD_MAX
};

typedef struct
{
	int	PresetNum;	
	int	Dwell;		
	int	Speed;		
} DEV_CRUISE_POINT;

typedef struct
{
	int nIndex;
	int nPresetNum;
	int Dwell;
	int Speed;
}DEV_CRUISE_POINT2;

typedef struct
{
	DEV_CRUISE_POINT cruisePoint[32];
} PTZCruisePath;

class IDevCtlPtz
{
public:
    virtual int  GetSpeed(void) = 0;
	virtual void  SetSpeed(int iSpeed) = 0;
	virtual BOOL PTZControl(int iPTZType, DWORD dwStop) = 0;
	virtual BOOL PTZCruise(DWORD dwPTZCruiseCmd, BYTE byCruiseRoute, BYTE byCruisePoint, WORD wInput) = 0;
	virtual BOOL PTZPreset(DWORD dwPTZPresetCmd, DWORD dwPresetIndex) = 0;
	virtual BOOL GetPTZCruise(LONG lCruiseRoute, PTZCruisePath *lpCruise, LONG lChn = -1) = 0;
	virtual BOOL PTZTrack(DWORD dwPTZTrackCmd) = 0;
};

class DLLAPI CDevCtlPtzFactory
{
public:
	static IDevCtlPtz *CreateDevCtlPtz(IDevUserLogin *pUser, LONG lChannel, IDevPreview *p);
	static IDevCtlPtz *CreateDevCtlPtz(IDevUserLogin *pUser, IDevPreview *p);
	static void DeleteDevCtlPtz(IDevCtlPtz *pCtlPtz, IDevUserLogin *pUsr);
};

#endif
